/**********************************************************************************************
* Device      : AD18F08
* Author      :
* Version     : V0.0.1
* Date        : 2022.3.24
* Description : 演示FLASH页擦除和写读功能,先擦除Buf数组数据，擦除后读取打印全是FF;以2个字节(16Bit)写数据，
                高8位数据为0x0010+i,低8位数据为i,然后读取打印写入的数据(大端模式读取数据)
* 				4M下波特率为9600,Fcpu系统时钟频率改变时波特率应该随之改变，如8M时钟频率下波特率应设为19200，2M时钟频率下波特率应设为4800等
***********************************************************************************************/
#include <stdio.h>
#include "AD18F08.h"
#include "usart.h"
#include "periph.h"

/*********************************************************************************************
* 常用配置字功能说明：
*
* _FINTOSC_DIV1     :  内部时钟分频选择
* _DBG_OFF          :  禁用DEBUG模式（使能后DEBUG 口不能做普通IO用）
* _LVREN_ON         :  使能LVR
* _LVR24V           :  选择LVR电压为2.4V
* _FLASH_CP1_OFF    :  1K~2K*16 FLASH保护位
* _FLASH_CP0_OFF    :  0~1K*16 FLASH保护位
* _IDIS_OFF	     	:  模拟IO打开，数据读取控制位
* _CKSUM_OFF        :  使能程序校验
* _CBP_OFF			:  代码保护选择位
* _RESETE_OFF       :  禁用外部复位
* _RSEL_LOW			:  端口上下拉电阻选择
* _STV_ON		    :  堆栈溢出复位使能位
* _PSUT_2		    :  上电复位时间选择位
* _FCPU_4T          :  选择指令周期为4T模式
* _WDTE_OFF         :  看门狗使能位
* _TWDT_000         :  看门狗溢出时间选择位
* _OSCM_HIRC_16M    :  选择内部高速时钟16MHz
* _MTPDIS_OFF       ： SWD模式下读FLASH和EEPROM控位
* _ADCSP_ON			:  ADC采集速度选择位
*
* 注意：1.配置字若无特别需求请勿修改；
*       2.其他配置字及相应功能见Datasheet及头文件；
*
************************************************************************************************/
__CONFIG(1,_FINTOSC_DIV1_1L     & _DBG_OFF_1L       & _LVREN_OFF_1L     & _LVR24V_1L                                                                   );
__CONFIG(2,_FLASH_CP1_OFF_2L    & _FLASH_CP0_OFF_2L & _IDIS_OFF_2L     & _CKSUM_OFF_2L  & _CBP_OFF_2L   & _RESETE_OFF_2L & _RSEL_LOW_2L & _STV_ON_2L  );
__CONFIG(3,_PSUT_2_3L           & _FCPU_4T_3L       & _WDTE_OFF_3L    & _TWDT_100_3L                                                                 );
__CONFIG(4,_OSCM_HIRC_16M_4L    & _MTPDIS_OFF_4L    & _ADCSP_ON_4L                                                                                     );


// Flash一页是 128字节
volatile const unsigned char Buf[128] @ ADDR_FLASH1 ={
	0x00,0x01,0x02,0x03,0x04,0x05,0x06,0x07, 0x08,0x09,0x0A,0x0B,0x0C,0x0D,0x0E,0x0F,
	0x10,0x11,0x12,0x13,0x14,0x15,0x16,0x17, 0x18,0x19,0x1A,0x1B,0x1C,0x1D,0x1E,0x1F,
	0x20,0x21,0x22,0x23,0x24,0x25,0x26,0x27, 0x28,0x29,0x2A,0x2B,0x2C,0x2D,0x2E,0x2F,
	0x30,0x31,0x32,0x33,0x34,0x35,0x36,0x37, 0x38,0x39,0x3A,0x3B,0x3C,0x3D,0x3E,0x3F,
	0x40,0x41,0x42,0x43,0x44,0x45,0x46,0x47, 0x48,0x49,0x4A,0x4B,0x4C,0x4D,0x4E,0x4F,
	0x50,0x51,0x52,0x53,0x54,0x55,0x56,0x57, 0x58,0x59,0x5A,0x5B,0x5C,0x5D,0x5E,0x5F,
	0x60,0x61,0x62,0x63,0x64,0x65,0x66,0x67, 0x68,0x69,0x6A,0x6B,0x6C,0x6D,0x6E,0x6F,
	0x70,0x71,0x72,0x73,0x74,0x75,0x76,0x77, 0x78,0x79,0x7A,0x7B,0x7C,0x7D,0x7E,0x7F
};

unsigned short i;

void main(void)
{

	GPIO_INIT();  //GPIO初始化
	usart_init(); //串口初始化
	IAPWAIT = 7;  //Fcpu= 8Mhz IAPWAIT=15；Fcpu= 4Mhz   IAPWAIT=7；Fcpu= 2Mhz IAPWAIT=4
				  //Fcpu= 1Mhz IAPWAIT= 1；Fcpu= 500Khz IAPWAIT=0；

	//step1: 整页FLASH擦除（擦除整页，每页128字节）
	FLASH_Erase(ADDR_FLASH1);		//按页擦除数据

	//读取擦除完成后的数据
	Falsh_Read_Array();       //数组读取
	// Falsh_Read_Pointer();  //指针读取

	//step2: 双字节写
	for(i = 0;i < 128; i+=2)
	{
		FLASH_Write(ADDR_FLASH1+i, ((0x0010+i) << 8) + i);	//每次写2个字节
	}
    //step3: 读取FLASH写入的数据
    Falsh_Read_Array();       //数组读取
	// Falsh_Read_Pointer();  //指针读取
	while(1)
	{
		;
	}
}

//中断服务函数
void interrupt ISR_h (void)
{

}


void interrupt low_priority ISR_l (void)
{

}
